/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb.server;

import gnu.logging.VLogger;
import gnu.rfb.server.RFBAuthenticator;
import gnu.rfb.server.RFBServer;
import gnu.rfb.server.RFBSocket;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Iterator;

public class RFBHost
implements Runnable {
    private int display;
    private String displayName;
    private RFBAuthenticator authenticator;
    private Constructor constructor;
    private RFBServer sharedServer = null;
    private boolean isRunning;
    private boolean threadFinished;
    private ServerSocket serverSocket;
    private ArrayList servers = new ArrayList();

    public RFBHost(int display, String displayName, Class rfbServerClass, RFBAuthenticator authenticator) throws NoSuchMethodException {
        this.constructor = rfbServerClass.getDeclaredConstructor(Integer.TYPE, String.class);
        if (!RFBServer.class.isAssignableFrom(rfbServerClass)) {
            throw new NoSuchMethodException("Class does not support RFBServer interface");
        }
        this.display = display;
        this.displayName = displayName;
        this.authenticator = authenticator;
        new Thread(this).start();
    }

    public synchronized void setSharedServer(RFBServer sharedServer) {
        this.sharedServer = sharedServer;
    }

    public synchronized RFBServer getSharedServer() {
        return this.sharedServer;
    }

    @Override
    public void run() {
        this.isRunning = true;
        this.threadFinished = false;
        try {
            this.serverSocket = new ServerSocket(5900 + this.display);
            this.setSharedServer((RFBServer)this.constructor.newInstance(new Integer(this.display), this.displayName));
        }
        catch (Exception e) {
            VLogger.getLogger().log("Got an exception, shutting down server VNCServer for: " + this.displayName, e);
            this.close();
        }
        while (this.isRunning()) {
            try {
                RFBSocket r = new RFBSocket(this.serverSocket.accept(), this.getSharedServer(), this, this.authenticator);
                this.servers.add(r);
            }
            catch (IOException e) {
                if (!this.isRunning()) {
                    System.out.println("Server Stopped.");
                    return;
                }
                throw new RuntimeException("Error accepting client connection", e);
            }
        }
        this.threadFinished = true;
        System.out.println("Thread Finished");
    }

    public void close() {
        try {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
                this.isRunning = false;
                while (!this.threadFinished) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Iterator iter = this.servers.iterator();
                while (iter.hasNext()) {
                    ((RFBSocket)iter.next()).close();
                }
            }
            catch (IOException e) {
                VLogger.getLogger().log("Got an exception while shutting down server VNCServer for: " + this.displayName, e);
                this.serverSocket = null;
            }
        }
        finally {
            this.serverSocket = null;
        }
    }

    public synchronized void stop() {
        this.isRunning = false;
        Iterator iter = this.servers.iterator();
        while (iter.hasNext()) {
            ((RFBSocket)iter.next()).close();
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error closing server", ex);
        }
        System.out.println("end of the work");
        Thread.currentThread().interrupt();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private synchronized boolean isRunning() {
        return this.isRunning;
    }
}

